﻿Imports System.Math
Imports System.IO
Public Class frmCapacitePieu
    Dim fc As Integer = 25
    Dim Classe_pieu As Integer = 1
    Dim TerrainStable As Boolean = False
    Dim BetonAsec As Boolean = False
    Dim B As Double = 0.6
    Dim L As Double = 5
    Dim Controle As Boolean = False
    Private Sub frmCapacitePieu_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        '--> création des répertoires Aide si n'existe pas
        'ce qui est le cas lors de l'installation du logiciel
        If My.Computer.FileSystem.DirectoryExists(Directory.GetCurrentDirectory.ToString() & "\Aide") = False Then
            Try
                Dim zipPath As String = Directory.GetCurrentDirectory.ToString() & "\Aide.zip"
                My.Computer.FileSystem.CreateDirectory(Directory.GetCurrentDirectory.ToString() & "\Aide")
                Dim extractPath As String = Directory.GetCurrentDirectory.ToString() & "\Aide"
                System.IO.Compression.ZipFile.ExtractToDirectory(zipPath, extractPath)
            Catch ex As Exception
                MessageBox.Show("Problème de décompression du fichier Aide.zip" & Environment.NewLine & "Exception: " & ex.Message, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            End Try
        End If
        If My.Computer.FileSystem.DirectoryExists(Directory.GetCurrentDirectory.ToString() & "\Note_de_calcul") = False Then
            Try
                My.Computer.FileSystem.CreateDirectory(Directory.GetCurrentDirectory.ToString() & "\Note_de_calcul")
            Catch ex As Exception
                MessageBox.Show("Problème de création du répertoire pour le stockage des notes de calcul." & Environment.NewLine & "Exception: " & ex.Message, Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
            End Try
        End If
        Call ForceDot()
        Call Affichage()
    End Sub

    ''' <summary>Programme Force la culture à utiliser le point pour les décimales</summary>
    Public Sub ForceDot() ' Force la culture à utiliser le point pour les décimales

        Dim oldDecimalSeparator As String = Application.CurrentCulture.NumberFormat.NumberDecimalSeparator

        If Not oldDecimalSeparator = "." Then ' Si ce n'est pas un point
            Dim forceDotCulture As Globalization.CultureInfo
            forceDotCulture = CType(Application.CurrentCulture.Clone(), Globalization.CultureInfo)
            forceDotCulture.NumberFormat.NumberDecimalSeparator = "."
            Application.CurrentCulture = forceDotCulture
        End If
    End Sub
    Private Sub Affichage()
        Select Case fc
            Case 20 ' 
                CbBeton.Text = CbBeton.Items(0).ToString
            Case 25 ' 
                CbBeton.Text = CbBeton.Items(1).ToString
            Case 30 ' 
                CbBeton.Text = CbBeton.Items(2).ToString
            Case 35 ' 
                CbBeton.Text = CbBeton.Items(3).ToString
            Case 40 ' 
                CbBeton.Text = CbBeton.Items(4).ToString
            Case 45 ' 
                CbBeton.Text = CbBeton.Items(5).ToString
            Case 50 ' 
                CbBeton.Text = CbBeton.Items(6).ToString
        End Select

        Select Case Classe_pieu
            Case 1 ' Pieux forés et barrettes
                CbTypePieu.Text = CbTypePieu.Items(0).ToString
            Case 2 ' 
                CbTypePieu.Text = CbTypePieu.Items(1).ToString
            Case 3 ' 
                CbTypePieu.Text = CbTypePieu.Items(2).ToString
            Case 4 ' 
                CbTypePieu.Text = CbTypePieu.Items(3).ToString
        End Select
        If Classe_pieu = 1 Then
            ChkbClasse1Terrain.Visible = True : ChkbClasse1Asec.Visible = True : BtnHlpParoiStable.Visible = True
            If TerrainStable = True Then ChkbClasse1Terrain.Checked = True Else ChkbClasse1Terrain.Checked = False
            If BetonAsec = True Then ChkbClasse1Asec.Checked = True Else ChkbClasse1Asec.Checked = False
        Else
            ChkbClasse1Terrain.Visible = False : ChkbClasse1Asec.Visible = False : BtnHlpParoiStable.Visible = False
        End If
        txtB.Text = (B * 100).ToString("#0")
        txtL.Text = L.ToString("#0.00")
        If Controle = True Then ChkbControle.Checked = True Else ChkbControle.Checked = False
    End Sub

    Private Sub BtnAfficher_Click(sender As Object, e As EventArgs) Handles BtnAfficher.Click
        Dim fck, fcd_ArmaYes, fcd_ArmaNo, σmoy, σMax, PELS, PELUArme, PELUNonArme As Double
        Dim Verif As Boolean = True
        Call Lecture(Verif)
        If Verif = False Then Exit Sub
        Call Calcul(fck, fcd_ArmaYes, fcd_ArmaNo, σmoy, σMax, PELS, PELUArme, PELUNonArme)
        Call Affichage_Resultats(fck, fcd_ArmaYes, fcd_ArmaNo, σmoy, σMax, PELS, PELUArme, PELUNonArme)

    End Sub
    Private Sub Lecture(ByRef Verif As Boolean)
        Select Case CbBeton.SelectedIndex
            Case 0 ' 
                fc = 25
            Case 1 ' 
                fc = 30
            Case 2 ' 
                fc = 35
            Case 3 ' 
                fc = 40
            Case 4 ' 
                fc = 45
            Case 5 ' 
                fc = 50
        End Select
        Select Case CbTypePieu.SelectedIndex
            Case 0 ' Pieux forés et barrettes
                Classe_pieu = 1
            Case 1 ' 
                Classe_pieu = 2
            Case 2 ' 
                Classe_pieu = 3
            Case 3 ' 
                Classe_pieu = 4
        End Select
        If Classe_pieu = 1 Then
            If ChkbClasse1Terrain.Checked = True Then TerrainStable = True Else TerrainStable = False
            If ChkbClasse1Asec.Checked = True Then BetonAsec = True Else BetonAsec = False
        End If
        If GestionderreurTextbox(txtB, EP1) = True Then B = CDbl(txtB.Text) / 100 Else Verif = False
        If GestionderreurTextbox(txtL, EP1) = True Then L = CDbl(txtL.Text) Else Verif = False
        If ChkbControle.Checked = True Then Controle = True Else Controle = False
    End Sub

    ''' <summary>Programme de gestion des entrées dans les textbox</summary>
    '''  <param name="e">ByVal e As System.Windows.Forms.TextBox</param>
    ''' <param name="ep1">ByRef ep1 As System.Windows.Forms.ErrorProvider</param>
    Private Function GestionderreurTextbox(ByVal e As System.Windows.Forms.TextBox, ByRef ep1 As System.Windows.Forms.ErrorProvider) As Boolean
        Try
            GestionderreurTextbox = True
            If e.Text = "" Then
                ep1.SetError(e, "le champ n'a pas été renseigné!!")
                GestionderreurTextbox = False
            ElseIf e.Text <> "" Then
                Dim isnum As Boolean
                Dim retnum As Double
                Dim toto As String
                toto = Convert.ToString(e.Text) : toto = toto.Trim(" "c)
                isnum = Double.TryParse(toto, System.Globalization.NumberStyles.AllowLeadingSign Or System.Globalization.NumberStyles.AllowDecimalPoint, System.Globalization.NumberFormatInfo.CurrentInfo, retnum)
                If isnum = False Then
                    ep1.SetError(e, "le champ n'est pas une valeur numérique !!")
                    GestionderreurTextbox = False
                Else
                    ep1.SetError(e, "") ' Clear the error.
                    GestionderreurTextbox = True
                End If
            End If
        Catch ex As Exception
            ep1.SetError(e, ex.Message)
            GestionderreurTextbox = False
        End Try
    End Function

    Private Sub Calcul(ByRef fck As Double, ByRef fcd_ArmaYes As Double, ByRef fcd_ArmaNo As Double, ByRef σmoy As Double, ByRef σMax As Double, ByRef PELS As Double, ByRef PELUArme As Double, ByRef PELUNonArme As Double)
        Dim k1, k2, k3, aire As Double
        Dim Cmax As Integer
        Select Case Classe_pieu
            Case 1 ' Pieux forés et barrettes
                Cmax = 35 : k1 = 1.3
                If TerrainStable = True Then k1 = 1.2
                If BetonAsec = True Then k1 = 1.2
            Case 2 ' pieu tariere creuse
                Cmax = 30 : k1 = 1.35
            Case 3, 4 ' 
                Cmax = 35 : k1 = 1.3
        End Select
        k2 = 1
        If L / B >= 20 Then k2 = 1.05
        If B < 0.6 Then k2 = 1.3 - (B / 2)
        If L / B >= 20 AndAlso B < 0.6 Then k2 = 1.35 - (B / 2)
        fck = Min(Cmax / (k1 * k2), fc / (k1 * k2))
        If Classe_pieu = 2 AndAlso fck < 18.33 Then fck = 18.33
        If Controle = True Then k3 = 1.2 Else k3 = 1
        fcd_ArmaYes = Min(1 * k3 * fck / 1.5, 1 * Cmax / 1.5)
        fcd_ArmaNo = Min(0.8 * k3 * fck / 1.5, 0.8 * Cmax / 1.5)
        σmoy = 0.3 * k3 * fck
        σMax = Min(0.6 * k3 * fck, 0.6 * fc)
        aire = PI * B ^ 2 / 4
        PELS = σmoy * aire * 1000
        PELUArme = fcd_ArmaYes * aire * 1000
        PELUNonArme = fcd_ArmaNo * aire * 1000
    End Sub
    Private Sub Affichage_Resultats(fck As Double, fcd_ArmaYes As Double, fcd_ArmaNo As Double, σmoy As Double, σMax As Double, ByVal PELS As Double, ByVal PELUArme As Double, ByVal PELUNonArme As Double)
        lblFck.Text = fck.ToString("#0.00")
        lblFcdArme.Text = fcd_ArmaYes.ToString("#0.00")
        lblFcdNonArme.Text = fcd_ArmaNo.ToString("#0.00")
        lblMoyen.Text = σmoy.ToString("#0.00")
        lblMax.Text = σMax.ToString("#0.00")
        LblPELSCar.Text = PELS.ToString("#,##0.00")
        LblPELUArme.Text = PELUArme.ToString("#,##0.00")
        LblPELUNonArme.Text = PELUNonArme.ToString("#,##0.00")
    End Sub

#Region "Gestion des Textbox"
    Private Sub txtB_KeyPress(sender As Object, e As KeyPressEventArgs) Handles txtB.KeyPress
        Call Gestion_Keypress(e, txtB, True, True)
    End Sub

    Private Sub txtL_KeyPress(sender As Object, e As KeyPressEventArgs) Handles txtL.KeyPress
        Call Gestion_Keypress(e, txtL, True, False)
    End Sub
    ''' <summary>Programme de gestion des touches pressées dans le cadre ou l'entrée doit être exclusivement numérique</summary>
    '''  <param name="positif">variable prenant la valeur Vrai si la valeur doit être un nombre positif</param>
    ''' <param name="entier"> variable prenant la valeur Vrai si la valeur doit être un entier</param>
    Private Sub Gestion_Keypress(ByRef ee As System.Windows.Forms.KeyPressEventArgs, ByVal text1 As System.Windows.Forms.TextBox, ByVal positif As Boolean, ByVal entier As Boolean)
        Dim Lettre1 As Boolean = False

        If text1.SelectionLength = text1.Text.Length Then text1.Clear() : Lettre1 = True 'Pour gérer la 1ière lettre tapée dans le textbox
        If ee.KeyChar = "," Then
            If Lettre1 = False And entier = False Then 'le text1 comporte plus de 1 chiffre et le chiffre ne doit pas être un entier, remplacer . par ,
                'Pour éviter d'avoir plusieurs points ou virgule
                Dim texte As String = text1.Text
                If texte.Contains(",") OrElse texte.Contains(".") Then ee.Handled = True : Exit Sub
                text1.Text = text1.Text + "."
                text1.SelectionStart = text1.TextLength + 1
            End If
            ee.Handled = True
            Exit Sub
        End If
        If ee.KeyChar = "." Then
            If Lettre1 = True Then 'le text1 comporte  1 chiffre, on ne valide pas la frappe
                ee.Handled = True
                Exit Sub
            ElseIf entier = True Then
                ee.Handled = True
                Exit Sub
            Else
                'Pour éviter d'avoir plusieurs points ou virgule
                Dim texte As String = text1.Text
                If texte.Contains(".") OrElse texte.Contains(",") Then ee.Handled = True : Exit Sub
            End If
        End If
        If ee.KeyChar = "&" Then
            text1.Text = text1.Text + "1"
            text1.SelectionStart = text1.TextLength + 1
            ee.Handled = True
            Exit Sub
        End If
        If ee.KeyChar = "é" Then
            text1.Text = text1.Text + "2"
            text1.SelectionStart = text1.TextLength + 1
            ee.Handled = True
            Exit Sub
        End If
        If ee.KeyChar = Convert.ToChar(34) Then 'ascw(ee.KeyChar) = 34 code " = keyAscii = 34
            text1.Text = text1.Text + "3"
            text1.SelectionStart = text1.TextLength + 1
            ee.Handled = True
            Exit Sub
        End If
        If ee.KeyChar = "'" Then
            text1.Text = text1.Text + "4"
            text1.SelectionStart = text1.TextLength + 1
            ee.Handled = True
            Exit Sub
        End If
        If ee.KeyChar = "(" Then
            text1.Text = text1.Text + "5"
            text1.SelectionStart = text1.TextLength + 1
            ee.Handled = True
            Exit Sub
        End If
        If positif = True Then 'seulement si la valeur >0
            If ee.KeyChar = "-" Then
                text1.Text = text1.Text + "6"
                text1.SelectionStart = text1.TextLength + 1
                ee.Handled = True
                Exit Sub
            End If
        Else
            If ee.KeyChar = "-" Then
                text1.Text = "-"
                text1.SelectionStart = text1.TextLength + 1
                ee.Handled = True
                Exit Sub
            End If
        End If
        If ee.KeyChar = "è" Then
            text1.Text = text1.Text + "7"
            text1.SelectionStart = text1.TextLength + 1
            ee.Handled = True
            Exit Sub
        End If
        If ee.KeyChar = "_" Then
            text1.Text = text1.Text + "8"
            text1.SelectionStart = text1.TextLength + 1
            ee.Handled = True
            Exit Sub
        End If
        If ee.KeyChar = "ç" Then
            text1.Text = text1.Text + "9"
            text1.SelectionStart = text1.TextLength + 1
            ee.Handled = True
            Exit Sub
        End If
        If ee.KeyChar = "à" Then
            text1.Text = text1.Text + "0"
            text1.SelectionStart = text1.TextLength + 1
            ee.Handled = True
            Exit Sub
        End If
        If checkUnicode(ee) = 0 Then ee.Handled = True
    End Sub
    Private Function checkUnicode(ByVal ee As System.Windows.Forms.KeyPressEventArgs) As Integer
        checkUnicode = 1
        If ee.KeyChar = Convert.ToChar(8) Then Exit Function ' touche del utilisable
        '    If ee.KeyChar = Convert.ToChar(44) Then Exit Function ' touche , utilisable
        If ee.KeyChar = "." Then Exit Function ' touche . utilisable Convert.ToChar(46) 
        If ee.KeyChar = "0" Then Exit Function '0Convert.ToChar(48)
        If ee.KeyChar = "1" Then Exit Function '1 Convert.ToChar(49)
        If ee.KeyChar = "2" Then Exit Function '2Convert.ToChar(50)
        If ee.KeyChar = "3" Then Exit Function '3Convert.ToChar(51)
        If ee.KeyChar = "4" Then Exit Function '4Convert.ToChar(52)
        If ee.KeyChar = "5" Then Exit Function '5Convert.ToChar(53)
        If ee.KeyChar = "6" Then Exit Function '6Convert.ToChar(54)
        If ee.KeyChar = "7" Then Exit Function '7Convert.ToChar(55)
        If ee.KeyChar = "8" Then Exit Function '8Convert.ToChar(56)
        If ee.KeyChar = "9" Then Exit Function '9Convert.ToChar(57)
        checkUnicode = 0
    End Function

#End Region

    Private Sub CbTypePieu_SelectedIndexChanged(sender As Object, e As EventArgs) Handles CbTypePieu.SelectedIndexChanged
        If CbTypePieu.SelectedIndex = 0 Then
            ChkbClasse1Terrain.Visible = True : ChkbClasse1Asec.Visible = True : BtnHlpParoiStable.Visible = True
        Else
            ChkbClasse1Terrain.Visible = False : ChkbClasse1Asec.Visible = False : BtnHlpParoiStable.Visible = False
        End If
    End Sub

#Region "Gestion des boutons d'Aide"

    Private Sub BtnHlpParoiStable_Click(sender As Object, e As EventArgs) Handles BtnHlpParoiStable.Click
        Dim frm1 As frmAide
        frm1 = New frmAide
        frm1.FichierAide = 1
        frm1.Show()
    End Sub

    Private Sub BtnHlpK2_Click(sender As Object, e As EventArgs) Handles BtnHlpK2.Click
        Dim frm1 As frmAide
        frm1 = New frmAide
        frm1.FichierAide = 2
        frm1.Show()
    End Sub

    Private Sub BtnHlpFck_Click(sender As Object, e As EventArgs) Handles BtnHlpFck.Click
        Dim frm1 As frmAide
        frm1 = New frmAide
        frm1.FichierAide = 3
        frm1.Show()
    End Sub

    Private Sub BtnHlpControleRenforce_Click(sender As Object, e As EventArgs) Handles BtnHlpControleRenforce.Click
        Dim frm1 As frmAide
        frm1 = New frmAide
        frm1.FichierAide = 4
        frm1.Show()
    End Sub
    Private Sub BtnHlpPieuArme_Click_1(sender As Object, e As EventArgs) Handles BtnHlpPieuArme.Click
        Dim frm1 As frmAide
        frm1 = New frmAide
        frm1.FichierAide = 5
        frm1.Show()
    End Sub
#End Region

    Private Sub BtnVersion_Click(sender As Object, e As EventArgs) Handles BtnVersion.Click
        Try
            Dim frm1 As New frmSplash
            frm1.Show()
            frm1 = Nothing 'pour libérer la mémoire
        Catch ex As Exception
            MessageBox.Show(ex.ToString, "Affichage version logiciel", MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
        End Try
    End Sub

    Private Sub BtnSauvegarde_Click(sender As Object, e As EventArgs) Handles BtnSauvegarde.Click
        Dim fck, fcd_ArmaYes, fcd_ArmaNo, σmoy, σMax, PELS, PELUArme, PELUNonArme As Double
        Dim Verif As Boolean = True
        Call Lecture(Verif)
        If Verif = False Then Exit Sub
        Call Calcul(fck, fcd_ArmaYes, fcd_ArmaNo, σmoy, σMax, PELS, PELUArme, PELUNonArme)
        Call Affichage_Resultats(fck, fcd_ArmaYes, fcd_ArmaNo, σmoy, σMax, PELS, PELUArme, PELUNonArme)
        'Ecriture de la note de calcul au format rtf
        Dim msg As String = String.Empty
        'writer de sortie du RTF
        Dim sw As New System.IO.StringWriter
        'crée un writer de RTF avec une police par défaut
        Dim rtf As New To_Rtf.RtfAnsiTextWriter(sw, New Font(FontFamily.GenericSerif, 12, FontStyle.Regular))
        Dim rtff As String
        rtf.Bold = True : rtf.FontSize = 16 : rtf.Underline = True
        rtf.WriteString("Note de calcul de la capacité en résistance de pieux suivant les Eurocodes")
        rtf.NewLine()
        rtf.Bold = False : rtf.FontSize = 10 : rtf.Underline = False : rtf.NewParagraph()
        rtf.WriteString("Note de calcul du : ") : msg = Mise_en_Forme(CStr(DateTime.Now)) : rtf.WriteString(msg) : rtf.NewLine()
        rtf.WriteString("Rédacteur : A renseigner") : rtf.NewLine()
        rtf.WriteString("Chantier : A renseigner") : rtf.NewLine()
        rtf.WriteString("Logiciel : " & My.Application.Info.Title & "  -  version " & My.Application.Info.Version.ToString & "  -  " & My.Application.Info.Copyright & " " & DateTime.Now.Year.ToString) : rtf.NewLine()
        rtf.NewLine() : rtf.FontSize = 12 : rtf.Bold = True : rtf.Underline = True
        rtf.WriteString("1 - Rappel des hypothèses") : rtf.Bold = False
        rtf.FontSize = 10 : rtf.Underline = False : rtf.NewLine() : rtf.NewLine()
        Select Case CbBeton.SelectedIndex
            Case 0 ' 
                msg = "C25/30"' fc = 25
            Case 1 ' 
                msg = "C30/37"'  fc = 30
            Case 2 ' 
                msg = "C35/45"' fc = 35
            Case 3 ' 
                msg = "C40/50"'   fc = 40
            Case 4 ' 
                msg = "C45/55"'  fc = 45
            Case 5 ' 
                msg = "C50/60" '  fc = 50
        End Select
        rtf.WriteString("Classe de résistance à la compression du béton du pieu : " & msg) : rtf.NewLine()
        Select Case CbTypePieu.SelectedIndex
            Case 0 ' Pieux forés et barrettes
                msg = "Pieux forés"'  Classe_pieu = 1 Pieux forés et barrettes
            Case 1 ' 
                msg = "Pieux tarière creuse avec enregistrement des paramètres"'Classe_pieu = 2  Pieux tarière creuse avec enregistrement des paramètres
            Case 2 ' 
                msg = "Pieux vissés moulés"'Classe_pieu = 3  Pieux vissés moulés
            Case 3 ' 
                msg = "Pieux battus moulés" 'Classe_pieu = 4  Pieux battus moulés
        End Select
        rtf.WriteString("Classe du pieu : " & msg) : rtf.NewLine()
        rtf.WriteString("Dimension transversale du pieu : " & (B * 100).ToString("#0.00") & " cm.") : rtf.NewLine()
        rtf.WriteString("Longueur du pieu : " & L.ToString("#0.00") & " m.") : rtf.NewLine()
        'uniquement pour les pieux forés
        If Classe_pieu = 1 Then
            If TerrainStable = True Then
                rtf.WriteString("Les parois du forage sont stables en raison de la nature des terrains traversés.") : rtf.NewLine() 'ChkbClasse1Terrain.Checked = True
            Else
                rtf.WriteString("Les parois du forage sont instables en raison de la nature des terrains traversés.") : rtf.NewLine() ' TerrainStable = False 
            End If
            If BetonAsec = True Then
                rtf.WriteString("Le pieu est tubé et bétonné à sec.") : rtf.NewLine() ' ChkbClasse1Asec.Checked = True
            Else
                rtf.WriteString("Aucun tubage et/ou bétonnage à sec prévu.") : rtf.NewLine() ' BetonAsec = False
            End If
        End If
        'pour tous les autres pieux
        If Controle = True Then
            rtf.WriteString("Mise en oeuvre avec Contrôle renforcé de la qualité d'exécution et de la continuité du fût, avec mise en oeuvre de la méthode d'auscultation suivant la NF P94-262.") : rtf.NewLine() ' Contrôle renforcé qualité et continuité du fût  ChkbControle.Checked = True
        Else
            rtf.WriteString("Aucun Contrôle qualité renforcé.") : rtf.NewLine() 'Controle = False
        End If
        rtf.NewLine() : rtf.FontSize = 12 : rtf.Bold = True : rtf.Underline = True
        rtf.WriteString("2 - Calculs") : rtf.Bold = False
        rtf.FontSize = 10 : rtf.Underline = False : rtf.NewLine() : rtf.NewLine()
        rtf.WriteString("Valeur caractéristique de la résistance à la compression du béton du pieu ou de la barrette fck* :  " & fck.ToString("#0.00") & " MPa.") : rtf.NewLine() : rtf.NewLine()
        rtf.WriteString("Valeur de calcul de la résistance à la compression simple du béton du pieu ou de la barrette :") : rtf.NewLine()
        rtf.WriteString("  - Pieu non armé - fcd :  " & fcd_ArmaNo.ToString("#0.00") & " MPa.") : rtf.NewLine()
        rtf.WriteString("  - Pieu armé - fcd :  " & fcd_ArmaYes.ToString("#0.00") & " MPa.") : rtf.NewLine() : rtf.NewLine()
        rtf.WriteString("Valeurs de résistance moyenne et maximale à la compression du béton du pieu ou de la barrette à l'ELS Caractéristique :") : rtf.NewLine()
        rtf.WriteString("  - σ moy :  " & σmoy.ToString("#0.00") & " MPa.") : rtf.NewLine()
        rtf.WriteString("  - σ Max :  " & σMax.ToString("#0.00") & " MPa.") : rtf.NewLine() : rtf.NewLine()
        rtf.WriteString("Charge Admissible en compression à l'ELS Caractéristique pour pieu circulaire - charge :  " & PELS.ToString("#,##0.00") & " kN.") : rtf.NewLine() : rtf.NewLine()
        rtf.WriteString("Charge Admissible en compression à l'ELU Str pour pieu circulaire :") : rtf.NewLine()
        rtf.WriteString("  - Pieu non armé - Charge :  " & PELUNonArme.ToString("#,##0.00") & " kN.") : rtf.NewLine()
        rtf.WriteString("  - Pieu armé - Charge :  " & PELUArme.ToString("#,##0.00") & " kN.") : rtf.NewLine()
        'génère le RTF complet
        Dim msgResult, Note_de_Calcul As String
        msgResult = Directory.GetCurrentDirectory.ToString() & "\Note_de_calcul"
        Note_de_Calcul = "Ndc_CapaPieuEC2_" & Mise_en_Forme(CStr(DateTime.Now)) & ".rtf"
        rtf.Generate() : rtff = sw.ToString : File.WriteAllText(msgResult & "\" & Note_de_Calcul, rtff)
        MessageBox.Show("Note de calcul rédigée et sauvegardée au format rtf." & Environment.NewLine & "Elle se trouve dans le répertoire " & msgResult, "Capacité de résistance de pieux en béton armé", MessageBoxButtons.OK,
                        MessageBoxIcon.Information)
    End Sub
    Private Function Mise_en_Forme(ByVal Toto As String) As String
        Dim toti As String
        toti = Toto.Replace("/", "_")   ' Replace(Toto, "/", "_")
        Toto = toti.Replace(" ", "_")
        toti = Toto.Replace(":", "_")
        Mise_en_Forme = toti
    End Function

    Private Sub BtnEffacer_Click(sender As Object, e As EventArgs) Handles BtnEffacer.Click
        lblFck.Text = ""
        lblFcdArme.Text = ""
        lblFcdNonArme.Text = ""
        lblMoyen.Text = ""
        lblMax.Text = ""
        LblPELSCar.Text = ""
        LblPELUArme.Text = ""
        LblPELUNonArme.Text = ""
    End Sub
End Class
